<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/**
 * Shortcode-Styling settings
 *
 * @param array $sections An array of our sections.
 * @return array
 */
function fusion_builder_redux_shortcode_styling( $sections ) {

	$option_name = 'fusion_builder_options';
	$settings = get_option( Avada::get_option_name(), array() );

	$sections['shortcode_styling'] = array(
		'label'    => esc_html__( 'Fusion Builder Elements', 'fusion-builder' ),
		'id'       => 'fusion_builder_elements',
		'is_panel' => true,
		'priority' => 14,
		'icon'     => 'el-icon-cog',
		'fields'   => array(
			'shortcode_animations_accordion' => array(
				'label'       => esc_html__( 'Animations', 'fusion-builder' ),
				'description' => '',
				'id'          => 'shortcode_animations_accordion',
				'default'     => '',
				'type'        => 'accordion',
				'fields'      => array(
					'animation_offset' => array(
						'label'       => esc_html__( 'Animation Offset', 'fusion-builder' ),
						'description' => esc_html__( 'Controls when the animation should start.', 'fusion-builder' ),
						'id'          => 'animation_offset',
						'default'     => 'top-into-view',
						'type'        => 'select',
						'option_name' => $option_name,
						'choices'     => array(
							'top-into-view'   => esc_html__( 'Top of element hits bottom of viewport', 'fusion-builder' ),
							'top-mid-of-view' => esc_html__( 'Top of element hits middle of viewport', 'fusion-builder' ),
							'bottom-in-view'  => esc_html__( 'Bottom of element enters viewport', 'fusion-builder' ),
						),
					),
				),
			),
			'blog_shortcode_section' => array(
				'label'       => esc_html__( 'Blog Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'blog_shortcode_section',
				'default'     => '',
				'type'        => 'accordion',
				'fields'      => array(
					'dates_box_color' => array(
						'label'       => esc_html__( 'Blog Date Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the date box in blog alternate and recent posts layouts.', 'fusion-builder' ),
						'id'          => 'dates_box_color',
						'default'     => '#eef0f2',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'button_shortcode_section' => array(
				'label'       => esc_html__( 'Button Element', 'fusion-builder' ),
				'id'          => 'button_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'button_size' => array(
						'label'       => esc_html__( 'Button Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the default button size.', 'fusion-builder' ),
						'id'          => 'button_size',
						'default'     => 'Large',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Small'  => esc_html__( 'Small', 'fusion-builder' ),
							'Medium' => esc_html__( 'Medium', 'fusion-builder' ),
							'Large'  => esc_html__( 'Large', 'fusion-builder' ),
							'XLarge' => esc_html__( 'X-Large', 'fusion-builder' ),
						),
					),
					'button_span' => array(
						'label'       => esc_html__( 'Button Span', 'fusion-builder' ),
						'description' => esc_html__( 'Controls if the button spans the full width of its container.', 'fusion-builder' ),
						'id'          => 'button_span',
						'default'     => 'no',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'yes' => esc_html__( 'Yes', 'fusion-builder' ),
							'no'  => esc_html__( 'No', 'fusion-builder' ),
						),
					),
					'button_shape' => array(
						'label'       => esc_html__( 'Button Shape', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the default button shape.', 'fusion-builder' ),
						'id'          => 'button_shape',
						'default'     => 'Round',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Square' => esc_html__( 'Square', 'fusion-builder' ),
							'Round'  => esc_html__( 'Round', 'fusion-builder' ),
							'Pill'   => esc_html__( 'Pill', 'fusion-builder' ),
						),
					),
					'button_type' => array(
						'label'       => esc_html__( 'Button Type', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the default button type.', 'fusion-builder' ),
						'id'          => 'button_type',
						'default'     => 'Flat',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Flat' => esc_html__( 'Flat', 'fusion-builder' ),
							'3d'   => esc_html__( '3D', 'fusion-builder' ),
						),
					),
					'button_typography' => array(
						'id'          => 'button_typography',
						'label'       => esc_html__( 'Button Typography', 'fusion-builder' ),
						'description' => esc_html__( 'These settings control the typography for all button text.', 'fusion-builder' ),
						'type'        => 'typography',
						'option_name' => $option_name,
						'choices'     => array(
							'font-family'    => true,
							'font-weight'    => true,
							'letter-spacing' => true,
						),
						'default'     => array(
							'font-family'    => 'PT Sans',
							'font-weight'    => '400',
							'letter-spacing' => '0',
						),
					),
					'button_gradient_top_color' => array(
						'label'       => esc_html__( 'Button Gradient Top Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the top color of the button background.', 'fusion-builder' ),
						'id'          => 'button_gradient_top_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_gradient_bottom_color' => array(
						'label'       => esc_html__( 'Button Gradient Bottom Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the bottom color of the button background.', 'fusion-builder' ),
						'id'          => 'button_gradient_bottom_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_gradient_top_color_hover' => array(
						'label'       => esc_html__( 'Button Gradient Top Hover Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the top hover color of the button background.', 'fusion-builder' ),
						'id'          => 'button_gradient_top_color_hover',
						'default'     => '#96c346',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_gradient_bottom_color_hover' => array(
						'label'       => esc_html__( 'Button Gradient Bottom Hover Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the bottom hover color of the button background.', 'fusion-builder' ),
						'id'          => 'button_gradient_bottom_color_hover',
						'default'     => '#96c346',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_accent_color' => array(
						'label'       => esc_html__( 'Button Accent Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the button border, divider, text and icon.', 'fusion-builder' ),
						'id'          => 'button_accent_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_accent_hover_color' => array(
						'label'       => esc_html__( 'Button Accent Hover Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the hover color of the button border, divider, text and icon.', 'fusion-builder' ),
						'id'          => 'button_accent_hover_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_bevel_color' => array(
						'label'       => esc_html__( 'Button Bevel Color For 3D Mode', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the bevel color of the buttons when using 3D button type.', 'fusion-builder' ),
						'id'          => 'button_bevel_color',
						'default'     => '#54770F',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'button_border_width' => array(
						'label'       => esc_html__( 'Button Border Width', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border width for buttons.', 'fusion-builder' ),
						'id'          => 'button_border_width',
						'default'     => '0',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '20',
							'step' => '1',
						),
					),
				),
			),
			'carousel_shortcode_section' => array(
				'label'       => esc_html__( 'Carousel Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'carousel_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'carousel_nav_color' => array(
						'label'       => esc_html__( 'Carousel Navigation Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the navigation box for carousel sliders.', 'fusion-builder' ),
						'id'          => 'carousel_nav_color',
						'default'     => 'rgba(0,0,0,0.6)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'carousel_hover_color' => array(
						'label'       => esc_html__( 'Carousel Hover Navigation Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the hover navigation box for carousel sliders.', 'fusion-builder' ),
						'id'          => 'carousel_hover_color',
						'default'     => 'rgba(0,0,0,0.7)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'carousel_speed' => array(
						'label'       => esc_html__( 'Carousel Speed', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the speed of all carousel elements. ex: 1000 = 1 second.', 'fusion-builder' ),
						'id'          => 'carousel_speed',
						'default'     => '2500',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '1000',
							'max'  => '20000',
							'step' => '250',
						),
					),
				),
			),
			'checklist_shortcode_section' => array(
				'label'       => esc_html__( 'Checklist Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'checklist_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'checklist_icons_color' => array(
						'label'       => esc_html__( 'Checklist Icon Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the checklist icon.', 'fusion-builder' ),
						'id'          => 'checklist_icons_color',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'checklist_circle' => array(
						'label'       => esc_html__( 'Checklist Circle', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on if you want to display a circle background for checklists.', 'fusion-builder' ),
						'id'          => 'checklist_circle',
						'default'     => '1',
						'type'        => 'switch',
						'option_name' => $option_name,
					),
					'checklist_circle_color' => array(
						'label'       => esc_html__( 'Checklist Circle Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the checklist circle background.', 'fusion-builder' ),
						'id'          => 'checklist_circle_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'fullwidth_shortcode_section' => array(
				'label'       => esc_html__( 'Container Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'fullwidth_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'container_padding_default' => array(
		              'label'       => esc_html__( 'Container Padding for Default Template', 'Avada' ),
		              'description' => esc_html__( 'Controls the top/right/bottom/left padding of the container element when using the Default page template. ', 'Avada' ),
		              'id'          => 'container_padding_default',
		              'choices'     => array(
		                'top'     => true,
		                'bottom'  => true,
		                'left'    => true,
		                'right'   => true,
		                'units'   => array( 'px', '%' ),
		              ),
		              'default'     => array(
		                'top'     => '0px',
		                'bottom'  => '0px',
		                'left'    => '0px',
		                'right'   => '0px',
		              ),
		              'type'        => 'spacing',
		              'option_name' => $option_name,
		            ),
					'container_padding_100' => array(
		              'label'       => esc_html__( 'Container Padding for 100% Width Template', 'Avada' ),
		              'description' => esc_html__( 'Controls the top/right/bottom/left padding of the container element when using the 100% width page template.', 'Avada' ),
		              'id'          => 'container_padding_100',
		              'choices'     => array(
		                'top'     => true,
		                'bottom'  => true,
		                'left'    => true,
		                'right'   => true,
		                'units'   => array( 'px', '%' ),
		              ),
		              'default'     => array(
		                'top'     => '0px',
		                'bottom'  => '0px',
		                'left'    => '30px',
		                'right'   => '30px',
		              ),
		              'type'        => 'spacing',
		              'option_name' => $option_name,
		            ),
					'full_width_bg_color' => array(
						'label'       => esc_html__( 'Container Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color of the container element.', 'fusion-builder' ),
						'id'          => 'full_width_bg_color',
						'default'     => 'rgba(255,255,255,0)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'full_width_border_size' => array(
						'label'       => esc_html__( 'Container Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the container element.', 'fusion-builder' ),
						'id'          => 'full_width_border_size',
						'default'     => '0',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '50',
							'step' => '1',
						),
					),
					'full_width_border_color' => array(
						'label'       => esc_html__( 'Container Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the container element.', 'fusion-builder' ),
						'id'          => 'full_width_border_color',
						'default'     => '#eae9e9',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'content_box_shortcode_section' => array(
				'label'       => esc_html__( 'Content Box Element', 'fusion-builder' ),
				'id'          => 'content_box_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'content_box_bg_color' => array(
						'label'       => esc_html__( 'Content Box Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color for content boxes.', 'fusion-builder' ),
						'id'          => 'content_box_bg_color',
						'default'     => 'rgba(255,255,255,0)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'content_box_title_size' => array(
						'label'       => esc_html__( 'Content Box Title Font Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the size of the title text. in pixels', 'fusion-builder' ),
						'id'          => 'content_box_title_size',
						'default'     => '18px',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'content_box_title_color' => array(
						'label'       => esc_html__( 'Content Box Title Font Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the title font.', 'fusion-builder' ),
						'id'          => 'content_box_title_color',
						'default'     => '#333333',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'content_box_body_color' => array(
						'label'       => esc_html__( 'Content Box Body Font Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the body font.', 'fusion-builder' ),
						'id'          => 'content_box_body_color',
						'default'     => '#747474',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'content_box_icon_size' => array(
						'label'       => esc_html__( 'Content Box Icon Font Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the size of the icon.', 'fusion-builder' ),
						'id'          => 'content_box_icon_size',
						'default'     => '21',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '250',
							'step' => '1',
						),
					),
					'content_box_icon_color' => array(
						'label'       => esc_html__( 'Content Box Icon Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the content box icon.', 'fusion-builder' ),
						'id'          => 'content_box_icon_color',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'content_box_icon_circle' => array(
						'label'       => esc_html__( 'Content Box Icon Background', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on to display a background behind the icon.', 'fusion-builder' ),
						'id'          => 'content_box_icon_circle',
						'default'     => 'yes',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'yes' => esc_html__( 'On', 'fusion-builder' ),
							'no'  => esc_html__( 'Off', 'fusion-builder' ),
						),
					),
					'content_box_icon_circle_radius' => array(
						'label'       => esc_html__( 'Content Box Icon Background Radius', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border radius of the icon background.', 'fusion-builder' ),
						'id'          => 'content_box_icon_circle_radius',
						'default'     => '50%',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'content_box_icon_bg_color' => array(
						'label'       => esc_html__( 'Content Box Icon Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the icon background.', 'fusion-builder' ),
						'id'          => 'content_box_icon_bg_color',
						'default'     => '#333333',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'content_box_icon_bg_inner_border_color' => array(
						'label'       => esc_html__( 'Content Box Icon Background Inner Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the inner border color of the icon background.', 'fusion-builder' ),
						'id'          => 'content_box_icon_bg_inner_border_color',
						'default'     => '#333333',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'content_box_icon_bg_inner_border_size' => array(
						'label'       => esc_html__( 'Content Box Icon Background Inner Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the inner border size of the icon background.', 'fusion-builder' ),
						'id'          => 'content_box_icon_bg_inner_border_size',
						'default'     => '1',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '20',
							'step' => '1',
						),
					),
					'content_box_icon_bg_outer_border_color' => array(
						'label'       => esc_html__( 'Content Box Icon Background Outer Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the outer border color of the icon background.', 'fusion-builder' ),
						'id'          => 'content_box_icon_bg_outer_border_color',
						'default'     => 'rgba(255,255,255,0)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'content_box_icon_bg_outer_border_size' => array(
						'label'       => esc_html__( 'Content Box Icon Background Outer Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the outer border size of the icon background.', 'fusion-builder' ),
						'id'          => 'content_box_icon_bg_outer_border_size',
						'default'     => '0',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '20',
							'step' => '1',
						),
					),
					'content_box_icon_hover_type' => array(
						'label'       => esc_html__( 'Content Box Hover Animation Type', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the hover effect of the icon.', 'fusion-builder' ),
						'id'          => 'content_box_icon_hover_type',
						'default'     => 'fade',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'none'    => esc_html__( 'None', 'fusion-builder' ),
							'fade'    => esc_html__( 'Fade', 'fusion-builder' ),
							'slide'   => esc_html__( 'Slide', 'fusion-builder' ),
							'pulsate' => esc_html__( 'Pulsate', 'fusion-builder' ),
						),
					),
					'content_box_hover_animation_accent_color' => array(
						'label'       => esc_html__( 'Content Box Hover Animation Accent Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the accent color for the hover animation.', 'fusion-builder' ),
						'id'          => 'content_box_hover_animation_accent_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'content_box_link_type' => array(
						'label'       => esc_html__( 'Content Box Link Type', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the type of link that displays in the content box.', 'fusion-builder' ),
						'id'          => 'content_box_link_type',
						'default'     => 'text',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'text'       => esc_html__( 'Text', 'fusion-builder' ),
							'button-bar' => esc_html__( 'Button Bar', 'fusion-builder' ),
							'button'     => esc_html__( 'Button', 'fusion-builder' ),
						),
					),
					'content_box_link_area' => array(
						'label'       => esc_html__( 'Content Box Link Area', 'fusion-builder' ),
						'description' => esc_html__( 'Controls which area the link will be assigned to.', 'fusion-builder' ),
						'id'          => 'content_box_link_area',
						'default'     => 'link-icon',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'link-icon' => esc_html__( 'Link + Icon', 'fusion-builder' ),
							'box'       => esc_html__( 'Entire Content Box', 'fusion-builder' ),
						),
					),
					'content_box_link_target' => array(
						'label'       => esc_html__( 'Content Box Link Target', 'fusion-builder' ),
						'description' => esc_html__( 'Controls how the link will open.', 'fusion-builder' ),
						'id'          => 'content_box_link_target',
						'default'     => '_self',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'_self'  => esc_html__( 'Same Window', 'fusion-builder' ),
							'_blank' => esc_html__( 'New Window/Tab', 'fusion-builder' ),
						),
					),
					'content_box_margin' => array(
						'label'       => esc_html__( 'Content Box Top/Bottom Margins', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the top/bottom margin for content boxes.', 'fusion-builder' ),
						'id'          => 'content_box_margin',
						'type'        => 'spacing',
						'option_name' => $option_name,
						'choices'     => array(
							'top'     => true,
							'bottom'  => true,
							'units'   => array( 'px', '%' ),
						),
						'default'     => array(
							'top'     => '0px',
							'bottom'  => '60px',
						),
					),
				),
			),
			'countdown_shortcode_section' => array(
				'label'  => esc_html__( 'Countdown Element', 'fusion-builder' ),
				'id'     => 'countdown_shortcode_section',
				'type'   => 'accordion',
				'fields' => array(
					'countdown_timezone' => array(
						'label'       => esc_html__( 'Countdown Timezone', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the timezone that is used for the countdown calculation.', 'fusion-builder' ),
						'id'          => 'countdown_timezone',
						'default'     => 'site_time',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'site_time' => esc_html__( 'Site Timezone', 'fusion-builder' ),
							'user_time' => esc_html__( 'User Timezone', 'fusion-builder' ),
						),
					),
					'countdown_show_weeks' => array(
						'label'       => esc_html__( 'Countdown Show Weeks', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on to display the number of weeks in the countdown.', 'fusion-builder' ),
						'id'          => 'countdown_show_weeks',
						'default'     => 'no',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'yes'     => esc_html__( 'On', 'fusion-builder' ),
							'no'      => esc_html__( 'Off', 'fusion-builder' ),
						),
					),
					'countdown_background_color' => array(
						'label'       => esc_html__( 'Countdown Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color for the countdown box.', 'fusion-builder' ),
						'id'          => 'countdown_background_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'countdown_background_image' => array(
						'label'       => esc_html__( 'Countdown Background Image', 'fusion-builder' ),
						'description' => esc_html__( 'Select an image for the countdown box background.', 'fusion-builder' ),
						'id'          => 'countdown_background_image',
						'default'     => '',
						'mod'         => '',
						'type'        => 'media',
						'option_name' => $option_name,
					),
					'countdown_background_repeat' => array(
						'label'       => esc_html__( 'Countdown Background Repeat', 'fusion-builder' ),
						'description' => esc_html__( 'Controls how the background image repeats.', 'fusion-builder' ),
						'id'          => 'countdown_background_repeat',
						'default'     => 'no-repeat',
						'type'        => 'select',
						'option_name' => $option_name,
						'choices'     => array(
							'repeat'    => esc_html__( 'Repeat All', 'fusion-builder' ),
							'repeat-x'  => esc_html__( 'Repeat Horizontal', 'fusion-builder' ),
							'repeat-y'  => esc_html__( 'Repeat Vertical', 'fusion-builder' ),
							'no-repeat' => esc_html__( 'Repeat None', 'fusion-builder' ),
						),
					),
					'countdown_background_position' => array(
						'label'       => esc_html__( 'Countdown Background Position', 'fusion-builder' ),
						'description' => esc_html__( 'Controls how the background image is positioned.', 'fusion-builder' ),
						'id'          => 'countdown_background_position',
						'default'     => 'center center',
						'type'        => 'select',
						'option_name' => $option_name,
						'choices'     => array(
							'top left'      => esc_html__( 'top left', 'fusion-builder' ),
							'top center'    => esc_html__( 'top center', 'fusion-builder' ),
							'top right'     => esc_html__( 'top right', 'fusion-builder' ),
							'center left'   => esc_html__( 'center left', 'fusion-builder' ),
							'center center' => esc_html__( 'center center', 'fusion-builder' ),
							'center right'  => esc_html__( 'center right', 'fusion-builder' ),
							'bottom left'   => esc_html__( 'bottom left', 'fusion-builder' ),
							'bottom center' => esc_html__( 'bottom center', 'fusion-builder' ),
							'bottom right'  => esc_html__( 'bottom right', 'fusion-builder' ),
						),
					),
					'countdown_counter_box_color' => array(
						'label'       => esc_html__( 'Countdown Counter Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color for the counter boxes.', 'fusion-builder' ),
						'id'          => 'countdown_counter_box_color',
						'default'     => '#333333',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'countdown_counter_text_color' => array(
						'label'       => esc_html__( 'Countdown Counter Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color for the countdown timer text.', 'fusion-builder' ),
						'id'          => 'countdown_counter_text_color',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'countdown_heading_text_color' => array(
						'label'       => esc_html__( 'Countdown Heading Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color for the countdown headings.', 'fusion-builder' ),
						'id'          => 'countdown_heading_text_color',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'countdown_subheading_text_color' => array(
						'label'       => esc_html__( 'Countdown Subheading Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color for the countdown subheadings.', 'fusion-builder' ),
						'id'          => 'countdown_subheading_text_color',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'countdown_link_text_color' => array(
						'label'       => esc_html__( 'Countdown Link Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color for the countdown link text.', 'fusion-builder' ),
						'id'          => 'countdown_link_text_color',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'countdown_link_target' => array(
						'label'       => esc_html__( 'Countdown Link Target', 'fusion-builder' ),
						'description' => esc_html__( 'Controls how the link will open.', 'fusion-builder' ),
						'id'          => 'countdown_link_target',
						'default'     => '_self',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'_self'  => esc_html__( 'Same Window', 'fusion-builder' ),
							'_blank' => esc_html__( 'New Window', 'fusion-builder' ),
						),
					),
				),
			),
			'counterb_shortcode_section' => array(
				'label'       => esc_html__( 'Counter Boxes Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'counterb_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'counter_box_speed' => array(
						'label'       => esc_html__( 'Counter Box Speed', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the speed of all counter box elements. ex: 1000 = 1 second.', 'fusion-builder' ),
						'id'          => 'counter_box_speed',
						'default'     => '1000',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '500',
							'max'  => '20000',
							'step' => '250',
						),
					),
					'counter_box_color' => array(
						'label'       => esc_html__( 'Counter Box Title Font Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the counter value and icon.', 'fusion-builder' ),
						'id'          => 'counter_box_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'counter_box_title_size' => array(
						'label'       => esc_html__( 'Counter Box Title Font Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the size of the counter value and icon.', 'fusion-builder' ),
						'id'          => 'counter_box_title_size',
						'default'     => '50px',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'counter_box_icon_size' => array(
						'label'       => esc_html__( 'Counter Box Icon Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the size of the icon.', 'fusion-builder' ),
						'id'          => 'counter_box_icon_size',
						'default'     => '50px',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'counter_box_body_color' => array(
						'label'       => esc_html__( 'Counter Box Body Font Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the counter box body text.', 'fusion-builder' ),
						'id'          => 'counter_box_body_color',
						'default'     => '#747474',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'counter_box_body_size' => array(
						'label'       => esc_html__( 'Counter Box Body Font Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the size of the counter box body text.', 'fusion-builder' ),
						'id'          => 'counter_box_body_size',
						'default'     => '13px',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'counter_box_border_color' => array(
						'label'       => esc_html__( 'Counter Box Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the counter box border.', 'fusion-builder' ),
						'id'          => 'counter_box_border_color',
						'default'     => '#e0dede',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'counter_box_icon_top' => array(
						'label'       => esc_html__( 'Counter Box Icon On Top', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on to display the icon on top of the counter value.', 'fusion-builder' ),
						'id'          => 'counter_box_icon_top',
						'default'     => 'no',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'yes' => esc_html__( 'On', 'fusion-builder' ),
							'no'  => esc_html__( 'Off', 'fusion-builder' ),
						),
					),
				),
			),
			'cc_shortcode_section' => array(
				'label'       => esc_html__( 'Counter Circle Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'cc_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'counter_filled_color' => array(
						'label'       => esc_html__( 'Counter Circle Filled Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the filled circle.', 'fusion-builder' ),
						'id'          => 'counter_filled_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'counter_unfilled_color' => array(
						'label'       => esc_html__( 'Counter Circle Unfilled Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the unfilled circle.', 'fusion-builder' ),
						'id'          => 'counter_unfilled_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'dropcap_shortcode_section' => array(
				'label'       => esc_html__( 'Dropcap Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'dropcap_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'dropcap_color' => array(
						'label'       => esc_html__( 'Dropcap Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the dropcap text, or the dropcap box if a box is used.', 'fusion-builder' ),
						'id'          => 'dropcap_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'faq_shortcode_section' => array(
				'label'       => esc_html__( 'FAQ Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'faq_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'faq_featured_image' => array(
						'label'       => esc_html__( 'FAQ Featured Images', 'Avada' ),
						'description' => esc_html__( 'Turn on to display featured images.', 'Avada' ),
						'id'          => 'faq_featured_image',
						'default'     => '0',
						'type'        => 'switch',
						'option_name' => $option_name,
					),
					'faq_filters' => array(
						'label'       => esc_html__( 'FAQ Filters', 'Avada' ),
						'description' => esc_html__( 'Controls how the filters display for FAQs.', 'Avada' ),
						'id'          => 'faq_filters',
						'default'     => 'yes',
						'type'        => 'radio-buttonset',
						'choices'     => array(
							'yes'             => esc_html__( 'Show', 'Avada' ),
							'yes_without_all' => esc_html__( 'Show without "All"', 'Avada' ),
							'no'              => esc_html__( 'Hide', 'Avada' ),
						),
						'option_name' => $option_name,
					),
				),
			),
			'flipb_shortcode_section' => array(
				'label'       => esc_html__( 'Flip Boxes Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'flipb_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'flip_boxes_front_bg' => array(
						'label'       => esc_html__( 'Flip Box Background Color Frontside', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the frontside background.', 'fusion-builder' ),
						'id'          => 'flip_boxes_front_bg',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'flip_boxes_front_heading' => array(
						'label'       => esc_html__( 'Flip Box Heading Color Frontside', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the frontside heading.', 'fusion-builder' ),
						'id'          => 'flip_boxes_front_heading',
						'default'     => '#333333',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'flip_boxes_front_text' => array(
						'label'       => esc_html__( 'Flip Box Text Color Frontside', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the frontside text.', 'fusion-builder' ),
						'id'          => 'flip_boxes_front_text',
						'default'     => '#747474',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'flip_boxes_back_bg' => array(
						'label'       => esc_html__( 'Flip Box Background Color Backside', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the backside background.', 'fusion-builder' ),
						'id'          => 'flip_boxes_back_bg',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'flip_boxes_back_heading' => array(
						'label'       => esc_html__( 'Flip Box Heading Color Backside', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the backside heading.', 'fusion-builder' ),
						'id'          => 'flip_boxes_back_heading',
						'default'     => '#eeeded',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'flip_boxes_back_text' => array(
						'label'       => esc_html__( 'Flip Box Text Color Backside', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the backside text.', 'fusion-builder' ),
						'id'          => 'flip_boxes_back_text',
						'default'     => '#ffffff',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'flip_boxes_border_size' => array(
						'label'       => esc_html__( 'Flip Box Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the flip box background.', 'fusion-builder' ),
						'id'          => 'flip_boxes_border_size',
						'default'     => '1',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '50',
							'step' => '1',
						),
					),
					'flip_boxes_border_color' => array(
						'label'       => esc_html__( 'Flip Box Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of flip box background.', 'fusion-builder' ),
						'id'          => 'flip_boxes_border_color',
						'default'     => 'rgba(0,0,0,0)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'flip_boxes_border_radius' => array(
						'label'       => esc_html__( 'Flip Box Border Radius', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border radius of the flip box background.', 'fusion-builder' ),
						'id'          => 'flip_boxes_border_radius',
						'default'     => '4px',
						'type'        => 'dimension',
						'option_name' => $option_name,
						'choices'     => array( 'px', '%', 'em' ),
					),
				),
			),
			'icon_shortcode_section' => array(
				'label'       => esc_html__( 'Icon Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'icon_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'icon_circle_color' => array(
						'label'       => esc_html__( 'Icon Circle Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the circle background.', 'fusion-builder' ),
						'id'          => 'icon_circle_color',
						'default'     => '#333333',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'icon_border_color' => array(
						'label'       => esc_html__( 'Icon Circle Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the circle background.', 'fusion-builder' ),
						'id'          => 'icon_border_color',
						'default'     => '#333333',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'icon_color' => array(
						'label'       => esc_html__( 'Icon Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the icon.', 'fusion-builder' ),
						'id'          => 'icon_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'imgf_shortcode_section' => array(
				'label'       => esc_html__( 'Image Frame Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'imgf_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'imgframe_border_color' => array(
						'label'       => esc_html__( 'Image Frame Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the image frame.', 'fusion-builder' ),
						'id'          => 'imgframe_border_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'imageframe_border_size' => array(
						'label'       => esc_html__( 'Image Frame Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the image frame.', 'fusion-builder' ),
						'id'          => 'imageframe_border_size',
						'default'     => '0',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '50',
							'step' => '1',
						),
					),
					'imageframe_border_radius' => array(
						'label'       => esc_html__( 'Image Frame Border Radius', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border radius of the image frame.', 'fusion-builder' ),
						'id'          => 'imageframe_border_radius',
						'default'     => '0px',
						'type'        => 'dimension',
						'option_name' => $option_name,
						'choices'     => array( 'px', '%' ),
					),
					'imgframe_style_color' => array(
						'label'       => esc_html__( 'Image Frame Style Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the style color of the image frame. Only works for glow and drop shadow style.', 'fusion-builder' ),
						'id'          => 'imgframe_style_color',
						'default'     => '#000000',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'modal_shortcode_section' => array(
				'label'       => esc_html__( 'Modal Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'modal_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'modal_bg_color' => array(
						'label'       => esc_html__( 'Modal Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color of the modal popup box.', 'fusion-builder' ),
						'id'          => 'modal_bg_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'modal_border_color' => array(
						'label'       => esc_html__( 'Modal Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the modal popup box.', 'fusion-builder' ),
						'id'          => 'modal_border_color',
						'default'     => '#ebebeb',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'person_shortcode_section' => array(
				'label'       => esc_html__( 'Person Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'person_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'person_shortcode_important_note_info' => array(
						'label'       => '',
						'description' => '<div class="avada-avadaredux-important-notice">' . __( '<strong>IMPORTANT NOTE:</strong> The styling options for the social icons used in the person element are controlled through the options under the "Social Icon Elements" section on this tab.', 'fusion-builder' ) . '</div>',
						'id'          => 'person_shortcode_important_note_info',
						'type'        => 'custom',
						'option_name' => $option_name,
					),
					'person_background_color' => array(
						'label'       => esc_html__( 'Person Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color of the person area.', 'fusion-builder' ),
						'id'          => 'person_background_color',
						'default'     => 'rgba(0,0,0,0)',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'person_border_color' => array(
						'label'       => esc_html__( 'Person Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the person image.', 'fusion-builder' ),
						'id'          => 'person_border_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'person_border_size' => array(
						'label'       => esc_html__( 'Person Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the person image.', 'fusion-builder' ),
						'id'          => 'person_border_size',
						'default'     => '0',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '50',
							'step' => '1',
						),
					),
					'person_border_radius' => array(
						'label'       => esc_html__( 'Person Border Radius', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border radius of the person image.', 'fusion-builder' ),
						'id'          => 'person_border_radius',
						'default'     => '0px',
						'type'        => 'dimension',
						'option_name' => $option_name,
						'choices'     => array( 'px', '%' ),
					),
					'person_style_color' => array(
						'label'       => esc_html__( 'Person Style Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the style color for all style types except border.', 'fusion-builder' ),
						'id'          => 'person_style_color',
						'default'     => '#000000',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'person_alignment' => array(
						'label'       => esc_html__( 'Person Content Alignment', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the alignment of the person content.', 'fusion-builder' ),
						'id'          => 'person_alignment',
						'default'     => 'Left',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Left'   => esc_html__( 'Left', 'fusion-builder' ),
							'Center' => esc_html__( 'Center', 'fusion-builder' ),
							'Right'  => esc_html__( 'Right', 'fusion-builder' ),
						),
					),
					'person_icon_position' => array(
						'label'       => esc_html__( 'Person Social Icon Position', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the position of the social icons.', 'fusion-builder' ),
						'id'          => 'person_icon_position',
						'default'     => 'Top',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Top'    => esc_html__( 'Top', 'fusion-builder' ),
							'Bottom' => esc_html__( 'Bottom', 'fusion-builder' ),
						),
					),
				),
			),
			'popover_shortcode_section' => array(
				'label'       => esc_html__( 'Popover Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'popover_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'popover_heading_bg_color' => array(
						'label'       => esc_html__( 'Popover Heading Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the popover heading background.', 'fusion-builder' ),
						'id'          => 'popover_heading_bg_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'popover_content_bg_color' => array(
						'label'       => esc_html__( 'Popover Content Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of popover content background.', 'fusion-builder' ),
						'id'          => 'popover_content_bg_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'popover_border_color' => array(
						'label'       => esc_html__( 'Popover Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of popover box.', 'fusion-builder' ),
						'id'          => 'popover_border_color',
						'default'     => '#ebebeb',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'popover_text_color' => array(
						'label'       => esc_html__( 'Popover Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the popover text.', 'fusion-builder' ),
						'id'          => 'popover_text_color',
						'default'     => '#747474',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'popover_placement' => array(
						'label'       => esc_html__( 'Popover Position', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the position of the popover in reference to the triggering element.', 'fusion-builder' ),
						'id'          => 'popover_placement',
						'default'     => 'Top',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Top'    => esc_html__( 'Top', 'fusion-builder' ),
							'Right'  => esc_html__( 'Right', 'fusion-builder' ),
							'Bottom' => esc_html__( 'Bottom', 'fusion-builder' ),
							'Left'   => esc_html__( 'Left', 'fusion-builder' ),
						),
					),
				),
			),
			'pricingtable_shortcode_section' => array(
				'label'       => esc_html__( 'Pricing Table Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'pricingtable_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'full_boxed_pricing_box_heading_color' => array(
						'label'       => esc_html__( 'Pricing Box Style 1 Heading Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of style 1 pricing table headings.', 'fusion-builder' ),
						'id'          => 'full_boxed_pricing_box_heading_color',
						'default'     => '#333333',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'sep_pricing_box_heading_color' => array(
						'label'       => esc_html__( 'Pricing Box Style 2 Heading Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of style 2 pricing table headings.', 'fusion-builder' ),
						'id'          => 'sep_pricing_box_heading_color',
						'default'     => '#333333',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'pricing_box_color' => array(
						'label'       => esc_html__( 'Pricing Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color portions of pricing boxes.', 'fusion-builder' ),
						'id'          => 'pricing_box_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'pricing_bg_color' => array(
						'label'       => esc_html__( 'Pricing Box Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the main background and title background.', 'fusion-builder' ),
						'id'          => 'pricing_bg_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'pricing_border_color' => array(
						'label'       => esc_html__( 'Pricing Box Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the outer border, pricing row and footer row backgrounds.', 'fusion-builder' ),
						'id'          => 'pricing_border_color',
						'default'     => '#f8f8f8',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'pricing_divider_color' => array(
						'label'       => esc_html__( 'Pricing Box Divider Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the dividers in-between pricing rows.', 'fusion-builder' ),
						'id'          => 'pricing_divider_color',
						'default'     => '#ededed',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'progressbar_shortcode_section' => array(
				'label'       => esc_html__( 'Progress Bar Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'progressbar_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'progressbar_height' => array(
						'label'       => esc_html__( 'Progress Bar Height', 'fusion-builder' ),
						'description' => esc_html__( 'Insert a height for the progress bar.', 'fusion-builder' ),
						'id'          => 'progressbar_height',
						'default'     => '37px',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'progressbar_text_position' => array(
						'label'       => esc_html__( 'Text Position', 'fusion-builder' ),
						'description' => esc_html__( 'Select the position of the progress bar text. Choose "Default" for theme option selection.', 'fusion-builder' ),
						'id'          => 'progressbar_text_position',
						'default'     => 'on_bar',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'on_bar'    => esc_html__( 'On Bar', 'fusion-builder' ),
							'above_bar'  => esc_html__( 'Above Bar', 'fusion-builder' ),
							'below_bar'  => esc_html__( 'Below Bar', 'fusion-builder' ),
						),
					),
					'progressbar_filled_color' => array(
						'label'       => esc_html__( 'Progress Bar Filled Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the progress bar filled area.', 'fusion-builder' ),
						'id'          => 'progressbar_filled_color',
						'default'     => '#a0ce4e',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'progressbar_filled_border_color' => array(
						'label'       => esc_html__( 'Progress Bar Filled Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the progress bar filled area.', 'fusion-builder' ),
						'id'          => 'progressbar_filled_border_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'progressbar_filled_border_size' => array(
						'label'       => esc_html__( 'Progress Bar Filled Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the progress bar filled area.', 'fusion-builder' ),
						'id'          => 'progressbar_filled_border_size',
						'default'     => '0',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '20',
							'step' => '1',
						),
					),
					'progressbar_unfilled_color' => array(
						'label'       => esc_html__( 'Progress Bar Unfilled Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the progress bar unfilled area.', 'fusion-builder' ),
						'id'          => 'progressbar_unfilled_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'progressbar_text_color' => array(
						'label'       => esc_html__( 'Progress Bar Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the progress bar text.', 'fusion-builder' ),
						'id'          => 'progressbar_text_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'sectionseparator_shortcode_section' => array(
				'label'       => esc_html__( 'Section Separator Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'sectionseparator_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'section_sep_border_size' => array(
						'label'       => esc_html__( 'Section Separator Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the section separator.', 'fusion-builder' ),
						'id'          => 'section_sep_border_size',
						'default'     => '1',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '50',
							'step' => '1',
						),
					),
					'section_sep_bg' => array(
						'label'       => esc_html__( 'Section Separator Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the background color of the section separator style.', 'fusion-builder' ),
						'id'          => 'section_sep_bg',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'section_sep_border_color' => array(
						'label'       => esc_html__( 'Section Separator Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the separator.', 'fusion-builder' ),
						'id'          => 'section_sep_border_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'separator_shortcode_section' => array(
				'label'       => esc_html__( 'Separator Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'separator_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'style_type' => array(
						'label'       => esc_html__( 'Separator Style', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the line style of all separators, divider lines on portfolio archives, blog archives, product archives and more.', 'fusion-builder' ),
						'id'          => 'separator_style_type',
						'default'     => 'double',
						'type'        => 'select',
						'option_name' => $option_name,
						'choices'       => array(
							'none'          => esc_attr__( 'No Style', 'fusion-builder' ),
							'single'        => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
							'double'        => esc_attr__( 'Double Border Solid', 'fusion-builder' ),
							'single|dashed' => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
							'double|dashed' => esc_attr__( 'Double Border Dashed', 'fusion-builder' ),
							'single|dotted' => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
							'double|dotted' => esc_attr__( 'Double Border Dotted', 'fusion-builder' ),
							'shadow'        => esc_attr__( 'Shadow', 'fusion-builder' ),
						),
					),
					'sep_color' => array(
						'label'       => esc_html__( 'Separator Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of all separators, divider lines and borders for meta, previous & next, filters, archive pages, boxes around number pagination, sidebar widgets, accordion divider lines, counter boxes and more.', 'fusion-builder' ),
						'id'          => 'sep_color',
						'default'     => '#e0dede',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'separator_circle' => array(
						'label'       => esc_html__( 'Separator Circle', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on if you want to display a circle around the separator icon.', 'fusion-builder' ),
						'id'          => 'separator_circle',
						'default'     => '1',
						'type'        => 'switch',
						'option_name' => $option_name,
					),
					'separator_border_size' => array(
						'label'       => esc_html__( 'Border Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border size of the separator.', 'fusion-builder' ),
						'id'          => 'separator_border_size',
						'default'     => '1',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '50',
							'step' => '1',
						),
					),
				),
			),
			'sociallinks_shortcode_section' => array(
				'label'       => esc_html__( 'Social Icon Elements', 'fusion-builder' ),
				'description' => '',
				'id'          => 'sociallinks_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'social_links_info' => array(
						'id'    => 'social_links_info',
						'type'  => 'raw',
						'option_name' => $option_name,
						'content'  => '<div class="avada-avadaredux-important-notice">' . __( '<strong>IMPORTANT NOTE:</strong> These social icon global options control both the social link element and person element.', 'fusion-builder' ) . '</div>',
					),
					'social_links_font_size' => array(
						'label'       => esc_html__( 'Social Links Icons Font Size', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the font size for the social link icons.', 'fusion-builder' ),
						'id'          => 'social_links_font_size',
						'default'     => '16px',
						'type'        => 'dimension',
						'option_name' => $option_name,
					),
					'social_links_color_type' => array(
						'label'       => esc_html__( 'Social Links Icon Color Type', 'fusion-builder' ),
						'description' => esc_html__( 'Custom colors allow you to choose a color for icons and boxes. Brand colors will use the exact brand color of each network for the icons or boxes.', 'fusion-builder' ),
						'id'          => 'social_links_color_type',
						'default'     => 'custom',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'custom' => esc_html__( 'Custom Colors', 'fusion-builder' ),
							'brand'  => esc_html__( 'Brand Colors', 'fusion-builder' ),
						),
					),
					'social_links_icon_color' => array(
						'label'       => esc_html__( 'Social Links Custom Icons Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the custom icons.', 'fusion-builder' ),
						'id'          => 'social_links_icon_color',
						'default'     => '#bebdbd',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
						'required'    => array(
							array(
								'setting'  => 'social_links_color_type',
								'operator' => '==',
								'value'    => 'custom',
							),
						),
					),
					'social_links_boxed' => array(
						'label'       => esc_html__( 'Social Links Icons Boxed', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on to have the icon displayed in a small box. Turn off to have the icon displayed with no box.', 'fusion-builder' ),
						'id'          => 'social_links_boxed',
						'default'     => '0',
						'type'        => 'switch',
						'option_name' => $option_name,
					),
					'social_links_box_color' => array(
						'label'       => esc_html__( 'Social Links Icons Custom Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Select a custom social icon box color.', 'fusion-builder' ),
						'id'          => 'social_links_box_color',
						'default'     => '#e8e8e8',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
						'required'    => array(
							array(
								'setting'  => 'social_links_boxed',
								'operator' => '==',
								'value'    => '1',
							),
							array(
								'setting'  => 'social_links_color_type',
								'operator' => '==',
								'value'    => 'custom',
							),
						),
					),
					'social_links_boxed_radius' => array(
						'label'       => esc_html__( 'Social Links Icons Boxed Radius', 'fusion-builder' ),
						'description' => esc_html__( 'Box radius for the social icons.', 'fusion-builder' ),
						'id'          => 'social_links_boxed_radius',
						'default'     => '4px',
						'type'        => 'dimension',
						'option_name' => $option_name,
						'choices'     => array( 'px', 'em' ),
						'required'    => array(
							array(
								'setting'  => 'social_links_boxed',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'social_links_boxed_padding' => array(
						'label'       => esc_html__( 'Social Links Icons Boxed Padding', 'fusion-builder' ),
						'id'          => 'social_links_boxed_padding',
						'default'     => '8px',
						'type'        => 'dimension',
						'option_name' => $option_name,
						'required'    => array(
							array(
								'setting'  => 'social_links_boxed',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'social_links_tooltip_placement' => array(
						'label'       => esc_html__( 'Social Links Icons Tooltip Position', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the tooltip position of the social links icons.', 'fusion-builder' ),
						'id'          => 'social_links_tooltip_placement',
						'default'     => 'Top',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'Top'    => esc_html__( 'Top', 'fusion-builder' ),
							'Right'  => esc_html__( 'Right', 'fusion-builder' ),
							'Bottom' => esc_html__( 'Bottom', 'fusion-builder' ),
							'Left'   => esc_html__( 'Left', 'fusion-builder' ),
							'None'   => esc_html__( 'None', 'fusion-builder' ),
						),
					),
				),
			),
			'tabs_shortcode_section' => array(
				'label'       => esc_html__( 'Tabs Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'tabs_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'tabs_bg_color' => array(
						'label'       => esc_html__( 'Tabs Background Color + Hover Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the active tab, tab hover and content background.', 'fusion-builder' ),
						'id'          => 'tabs_bg_color',
						'default'     => '#ffffff',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'tabs_inactive_color' => array(
						'label'       => esc_html__( 'Tabs Inactive Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the inactive tabs.', 'fusion-builder' ),
						'id'          => 'tabs_inactive_color',
						'default'     => '#ebeaea',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'tabs_border_color' => array(
						'label'       => esc_html__( 'Tabs Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the tab border.', 'fusion-builder' ),
						'id'          => 'tabs_border_color',
						'default'     => '#ebeaea',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'tagline_shortcode_section' => array(
				'label'       => esc_html__( 'Tagline Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'tagline_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'tagline_bg' => array(
						'label'       => esc_html__( 'Tagline Box Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the tagline box background.', 'fusion-builder' ),
						'id'          => 'tagline_bg',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'tagline_border_color' => array(
						'label'       => esc_html__( 'Tagline Box Border Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the border color of the tagline box.', 'fusion-builder' ),
						'id'          => 'tagline_border_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'tagline_margin' => array(
						'label'       => esc_html__( 'Tagline Top/Bottom Margins', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the top/bottom margin of the tagline box.', 'fusion-builder' ),
						'id'          => 'tagline_margin',
						'default'     => array(
							'top'     => '0px',
							'bottom'  => '84px',
						),
						'type'        => 'spacing',
						'option_name' => $option_name,
						'choices'     => array(
							'top'     => true,
							'bottom'  => true,
						),
					),
				),
			),
			'testimonials_shortcode_section' => array(
				'label'       => esc_html__( 'Testimonials Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'testimonials_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'testimonial_bg_color' => array(
						'label'       => esc_html__( 'Testimonial Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the testimonial background.', 'fusion-builder' ),
						'id'          => 'testimonial_bg_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'testimonial_text_color' => array(
						'label'       => esc_html__( 'Testimonial Text Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the testimonial text.', 'fusion-builder' ),
						'id'          => 'testimonial_text_color',
						'default'     => '#747474',
						'type'        => 'color',
						'option_name' => $option_name,
					),
					'testimonials_speed' => array(
						'label'       => esc_html__( 'Testimonials Speed', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the speed of the testimonial slider. ex: 1000 = 1 second.', 'fusion-builder' ),
						'id'          => 'testimonials_speed',
						'default'     => '4000',
						'type'        => 'slider',
						'option_name' => $option_name,
						'choices'     => array(
							'min'  => '0',
							'max'  => '20000',
							'step' => '250',
						),
					),
					'testimonials_random' => array(
						'label'       => esc_html__( 'Random Order', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on to display testimonials in a random order.', 'fusion-builder' ),
						'id'          => 'testimonials_random',
						'default'     => '0',
						'type'        => 'switch',
						'option_name' => $option_name,
					),
				),
			),
			'title_shortcode_section' => array(
				'label'       => esc_html__( 'Title Element', 'fusion-builder' ),
				'description' => '',
				'id'          => 'title_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'title_style_type' => array(
						'label'       => esc_html__( 'Title Separator', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the type of title separator that will display.', 'fusion-builder' ),
						'id'          => 'title_style_type',
						'default'     => 'double',
						'type'        => 'select',
						'option_name' => $option_name,
						'choices'     => array(
							'single'           => esc_html__( 'Single', 'fusion-builder' ),
							'single solid'     => esc_html__( 'Single Solid', 'fusion-builder' ),
							'single dashed'    => esc_html__( 'Single Dashed', 'fusion-builder' ),
							'single dotted'    => esc_html__( 'Single Dotted', 'fusion-builder' ),
							'double'           => esc_html__( 'Double', 'fusion-builder' ),
							'double solid'     => esc_html__( 'Double Solid', 'fusion-builder' ),
							'double dashed'    => esc_html__( 'Double Dashed', 'fusion-builder' ),
							'double dotted'    => esc_html__( 'Double Dotted', 'fusion-builder' ),
							'underline'        => esc_html__( 'Underline', 'fusion-builder' ),
							'underline solid'  => esc_html__( 'Underline Solid', 'fusion-builder' ),
							'underline dashed' => esc_html__( 'Underline Dashed', 'fusion-builder' ),
							'underline dotted' => esc_html__( 'Underline Dotted', 'fusion-builder' ),
							'none'             => esc_html__( 'None', 'fusion-builder' ),
						),
					),
					'title_border_color' => array(
						'label'       => esc_html__( 'Title Separator Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the title separators.', 'fusion-builder' ),
						'id'          => 'title_border_color',
						'default'     => '#e0dede',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
					'title_margin' => array(
						'label'       => esc_html__( 'Title Top/Bottom Margins', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the top/bottom margin of the titles. Leave empty to use corresponding heading margins.', 'fusion-builder' ),
						'id'          => 'title_margin',
						'default'     => array(
							'top'     => '0px',
							'bottom'  => '31px',
						),
						'type'        => 'spacing',
						'option_name' => $option_name,
						'choices'     => array(
							'top'     => true,
							'bottom'  => true,
						),
					),
				),
			),
			'accordion_shortcode_section' => array(
				'label'       => esc_html__( 'Toggles Element', 'fusion-builder' ),
				'id'          => 'accordion_shortcode_section',
				'type'        => 'accordion',
				'fields'      => array(
					'accordion_divider_line' => array(
						'label'       => esc_html__( 'Toggle Divider Line', 'fusion-builder' ),
						'description' => esc_html__( 'Turn on to display a divider line between each item.', 'fusion-builder' ),
						'id'          => 'accordion_divider_line',
						'default'     => '1',
						'type'        => 'switch',
						'option_name' => $option_name,
					),
					'accordian_inactive_color' => array(
						'label'       => esc_html__( 'Toggles Inactive Box Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the inactive toggle box.', 'fusion-builder' ),
						'id'          => 'accordian_inactive_color',
						'default'     => '#333333',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'user_login_shortcode_section' => array(
				'label'       => esc_html__( 'User Login Element', 'fusion-builder' ),
				'id'          => 'user_login_shortcode_section',
				'description' => '',
				'type'        => 'accordion',
				'fields'      => array(
					'user_login_text_align' => array(
						'label'       => esc_html__( 'User Login Text Align', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the alignment of all user login content. "Text Flow" follows the default text align of the site. "Center" will center all elements.', 'fusion-builder' ),
						'id'          => 'user_login_text_align',
						'default'     => 'center',
						'type'        => 'radio-buttonset',
						'option_name' => $option_name,
						'choices'     => array(
							'textflow' => esc_html__( 'Text Flow', 'fusion-builder' ),
							'center'   => esc_html__( 'Center', 'fusion-builder' ),
						),
					),
					'user_login_form_background_color' => array(
						'label'       => esc_html__( 'User Login Form Background Color', 'fusion-builder' ),
						'description' => esc_html__( 'Controls the color of the form background.', 'fusion-builder' ),
						'id'          => 'user_login_form_background_color',
						'default'     => '#f6f6f6',
						'type'        => 'color-alpha',
						'option_name' => $option_name,
					),
				),
			),
			'visibility_shortcode_section' => array(
				'label'       => esc_html__( 'Visibility Size Options', 'fusion-builder' ),
				'id'          => 'visibility_shortcode_section',
				'description' => '',
				'type'        => 'accordion',
				'fields'      => array(
					'visibility_small' => array(
						'label'       => esc_html__( 'Small Screen', 'fusion-builder' ),
						'description' => esc_html__( 'Controls when the small screen visibility should take effect.', 'fusion-builder' ),
						'id'          => 'visibility_small',
						'default'     => '640',
						'type'        => 'slider',
						'min'         => '0',
						'step'        => '1',
						'max'         => '2000',
						'option_name' => $option_name,
					),
					'visibility_medium' => array(
						'label'       => esc_html__( 'Medium Screen', 'fusion-builder' ),
						'description' => esc_html__( 'Controls when the medium screen visibility should take effect.', 'fusion-builder' ),
						'id'          => 'visibility_medium',
						'default'     => '1024',
						'type'        => 'slider',
						'min'         => '0',
						'step'        => '1',
						'max'         => '2000',
						'option_name' => $option_name,
					),
					'visibility_large' => array(
						'label'       => esc_html__( 'Large Screen', 'fusion-builder' ),
						'description' => esc_html__( 'Any screen larger than that which is defined as the medium screen will be counted as a large screen.', 'fusion-builder' ),
						'id'          => 'visibility_large',
						'full_width'  => false,
						'type'        => 'raw',
						'content'     => '<div id="avada-visibility-large">' . ( ( isset( $settings['visibility_medium'] ) && ! empty( $settings['visibility_medium'] ) ) ? '> <span>' . $settings['visibility_medium'] . '</span>' : '> <span>1200</span>' ) . '</div>',
						'option_name' => $option_name,
					),
				),
			),
		),
	);

	return $sections;

}
