<?php
/**
 * Shortcode for progressbars
 */

if ( ! class_exists( 'Massive_Progressbars' ) ) {

    class Massive_Progressbars extends Massive_Shortcode_Base {

        public function __construct() {
            $this->location = __DIR__;

            add_action( 'vc_before_init', array($this, 'map_to_vc') );
            add_shortcode( $this->get_tag(), array($this, 'render') );
        }

        /**
         * Map this shortcode with visual composer
         * @return void
         */
        public function map_to_vc() {
            vc_map( array(
                'name'                    => esc_html__( 'Progressbars', 'massive-engine'),
                'base'                    => $this->get_tag(),
                'category'                => esc_html__( 'Massive', 'massive-engine' ),
                'as_parent'               => array('only' => 'massive_progressbar'),
                'content_element'         => true,
                'show_settings_on_create' => false,
                'icon'                    => $this->get_icon('progress'),
                'is_container'            => true,
                "js_view"                 => 'VcColumnView'
            ) );
        }

        /**
         * render this shortcode
         * @param  array $atts
         * @param  string $content
         * @return string
         */
        public function render( $atts, $content = null ) {
            return do_shortcode( $content );
        }

    }

    new Massive_Progressbars;
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Massive_Progressbars extends WPBakeryShortCodesContainer {
    }
}
